<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php

/*
 * * 
 * @package  PageFlex
 * @author  PageFlex Team (technical@vinamost.net)
 * @copyright PageFlex Team
 * @link  http://page-flex.com
 * @since  Version 1.0
 * @filesource
 *
 */
if (is_admin()) {
    $bkrs = new Pf_Backup();
    $bak_folder = get_configuration('backup_dir');
    if (isset($_GET['action'])) {
        switch ($_GET['action']) {
            case 'restore':
                $message = $bkrs->restore($_GET['file']);
                break;
            case 'backup':
                $message = $bkrs->backup();
                break;
            case 'delete':
                $file = $bak_folder . $_GET['file'];
                if(is_file($file))
                    unlink($file);
                $_SESSION['success']=__('Backup file is removed successfully','configuration');
                break;
            case 'download':
                $bkrs->download($_GET['id']);
                break;
            case 'unset':
                unset($_SESSION['success']);
                break;
        }
    }

    require_once abs_plugin_path(__FILE__) . '/configuration/backup/action/main_tpl.php';
} else
    echo __('Access Denied!','configuration');